<?php
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Page Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'add_meta_boxes', 'reza_page_metabox' );
function reza_page_metabox($post){
      add_meta_box('reza_page_general_metabox',esc_html__('General Options','reza'), 'reza_page_general_metabox', 'page', 'normal' , 'high');
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Page General Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_page_general_metabox($post){
	global $post;
	wp_nonce_field( basename(__FILE__), 'reza_page_meta_nonce' );
 	
	   $custom = get_post_custom($post->ID);
	$sidebars  = reza_category_array_options('sidebars');
	$page_right = get_post_meta($post->ID, 'sidebar_page_right', true);
    $page_left = get_post_meta($post->ID, 'sidebar_page_left', true);
 	$full_width_value = get_post_meta($post->ID, 'full_width', true);
    if($full_width_value == "yes"){ $full_width_checked = 'checked="checked"';}else{$full_width_checked='';} 
	$hide_banner_below = get_post_meta($post->ID, 'hide_banner_below', true);
    $hide_comments = get_post_meta($post->ID, 'hide_comments', true);
     $body_background_color = get_post_meta($post->ID, 'body_background_color', true);
    $body_background_type = get_post_meta($post->ID, 'body_background_type', true);
    $body_background_image = get_post_meta($post->ID, 'body_background_image', true);
    $body_background_image_medium = get_post_meta($post->ID, 'body_background_image_medium', true);
    $body_background_pattern = get_post_meta($post->ID, 'body_background_pattern', true);
 

	?>
	 
	<table class="form-table meta_box">     
		<tbody>
                  <tr class="meta_reza_page_sidebar">
                <th ><label for="page_sidebar"><?php echo esc_html__('Custom Sidebar Right','reza');?></label></th>
                <td>
					<select name="sidebar_page_right" id="page_sidebar">
                          	<?php if(!empty($sidebars) && is_array($sidebars) ){  ?>
                        		<?php foreach ($sidebars as $key => $name){  ?>
                    			<option value="<?php echo ''.esc_attr($key) ?>" <?php  if ( $sidebars  == ''.$key ){ echo 'selected=""';} ?>><?php echo esc_html($name);?></option> 
							<?php }?>                      
							<?php }?>                      
                    </select>
                    
                </td>
            </tr> 
      <tr class="meta_reza_page_sidebar">
                <th ><label for="page_sidebar"><?php echo esc_html__('Custom Sidebar Left','reza');?></label></th>
                <td>
					<select name="sidebar_page_left" id="page_sidebar">
                          	<?php if(!empty($sidebars) && is_array($sidebars) ){  ?>
                        		<?php foreach ($sidebars as $key => $name){  ?>
                    			<option value="<?php echo ''.esc_attr($key) ?>" <?php  if ( $page_left  == ''.$key ){ echo 'selected=""';} ?>><?php echo esc_html($name);?></option> 
							<?php }?>                      
							<?php }?>                      
                    </select>
                    
                </td>
            </tr> 
            
            
            <tr class="meta_reza_full_width">
                <th ><label for="full_width"><?php echo esc_html__('Full Width Post','reza');?></label></th>
                <td>
    				<input type="checkbox" name="full_width"  id="full_width" value="yes" <?php echo wp_kses_post($full_width_checked); ?> />
                </td>
            </tr>            
      
            <tr class="meta_reza_hide_banner_below">
                <th ><label for="hide_banner_below"><?php echo esc_html__('Hide Below Ads Widget','reza');?></label></th>
                <td>
                    <select name="hide_banner_below" id="hide_banner_below">
                       <option value="default" <?php selected($hide_banner_below, 'default' ); ?>><?php echo esc_html__('Default','reza');?></option>
                      <option value="hide" <?php selected( $hide_banner_below, 'hide' ); ?>><?php echo esc_html__('Hide','reza');?></option>
                    </select>
                </td>
            </tr>            

            <tr class="meta_reza_hide_comments">
                <th ><label for="hide_comments"><?php echo esc_html__('Hide Comments','reza');?></label></th>
                <td>
                    <select name="hide_comments" id="hide_comments">
                       <option value="default" <?php selected($hide_comments, 'default' ); ?>><?php echo esc_html__('Default','reza');?></option>
                      <option value="hide" <?php selected( $hide_comments, 'hide' ); ?>><?php echo esc_html__('Hide','reza');?></option>
                    </select>
                </td>
            </tr>                
                        
            <tr class="meta_reza_body_background_color meta_reza_color">
                <th ><label for="body_background_color"><?php echo esc_html__('Background Color','reza');?></label></th>
                <td>
               		 <input  class="cs-wp-color-picker rd-color"  data-rgba="false" type="text" name="body_background_color" id="body_background_color" value="<?php echo esc_attr($body_background_color);?>">
                 </td>
            </tr> 
                        
         	<tr class="meta_reza_body_background_type">
                <th ><label for="body_background_type"><?php echo esc_html__('Background Type','reza');?></label></th>
                <td>
                    <select name="body_background_type" id="body_background_type">
                       <option value="" id="body_background_type_default" <?php selected($body_background_type, '' ); ?>><?php echo esc_html__('Default','reza');?></option>
                      <option value="none" id="body_background_type_none"  <?php selected( $body_background_type, 'none' ); ?>><?php echo esc_html__('None','reza');?></option>
                      <option value="pattern" id="body_background_type_pattern"  <?php selected( $body_background_type, 'pattern' ); ?>><?php echo esc_html__('Pattern','reza');?></option>
                      <option value="custom" id="body_background_type_custom"  <?php selected( $body_background_type, 'custom' ); ?>><?php echo esc_html__('Custom Image','reza');?></option>
                    </select>
                </td>
            </tr>            
            <tr class="meta_reza_body_background_pattern">
                <th ><label for="body_background_pattern"><?php echo esc_html__('Background Pattern','reza');?></label></th>
                <td>
 					<?php for ($i = 1; $i <= 23; $i++) {  ?>
                        <li>
                            <input  name="body_background_pattern" id="body_background_pattern-default"  value="<?php echo esc_attr($i) ?>" type="radio" <?php checked( $body_background_pattern, $i );?>>
                            <a><img src="<?php echo REZA_DIR;?>/images/bg/bg<?php echo esc_attr($i)?>.png"></a>
                         </li>                    
 					<?php }?>                      
                     
                </td>
            </tr> 
            
            <tr class="meta_reza_body_background_image">
                <th ><label for="body_background_image"><?php echo esc_html__('Custom Background Image','reza');?></label></th>
                <td> 
	  	 		<a class="rd_add_image button button-small"  data-uploader-title="<?php echo esc_attr__('Choose Image','reza');?>" data-uploader-button-text="<?php echo esc_attr__('Use This Image','reza');?>"> <?php echo esc_html__('Upload','reza')?></a>
 				<input type="hidden" name="body_background_image" value="<?php echo esc_url($body_background_image);?>">
 		
				<?php if(!empty($body_background_image)){     ?>
 	   			<a class="rd_remove_image button button-small" ><?php echo  esc_html__('Remove','reza');?></a>
 		 		<img   src="<?php echo esc_url($body_background_image) ?>"/> 
                <?php }?>
                </td>
            </tr>               
                    
 
                        
     	</tbody>
     </table>
    <?php
}  
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Save Page Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action('save_post', 'reza_save_page_metabox');
function reza_save_page_metabox( $post_id){ 
    global $post;
    if (!isset($_POST['reza_page_meta_nonce']) || !wp_verify_nonce($_POST['reza_page_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

  if (defined('DOING_AJAX') ) {
	return $post_id;
   }
	
	
	if (  isset($_POST['sidebar_page_right']) ) {
		update_post_meta($post_id, 'sidebar_page_right', $_POST['sidebar_page_right']);
	}else{
		delete_post_meta($post_id, 'sidebar_page_right');
	}			 
	
	if (  isset($_POST['sidebar_page_left']) ) {
		update_post_meta($post_id, 'sidebar_page_left', $_POST['sidebar_page_left']);
	}else{
		delete_post_meta($post_id, 'sidebar_page_left');
	}			 	
	   			 	
	   

	 	
	   
	if ( isset($_POST['full_width']) ) {
		update_post_meta($post_id, 'full_width', $_POST['full_width']);
	}else{
		delete_post_meta($post_id, 'full_width');
	}
	
	if ( isset($_POST['hide_post_tags']) ) {
		update_post_meta($post_id, 'hide_post_tags', $_POST['hide_post_tags']);
	}else{
		delete_post_meta($post_id, 'hide_post_tags');
	}		
	
	if (  isset($_POST['hide_post_meta']) ) {
		update_post_meta($post_id, 'hide_post_meta', $_POST['hide_post_meta']);
	}else{
		delete_post_meta($post_id, 'hide_post_meta');
	}		
	
	if (  isset($_POST['hide_post_share']) ) {
		update_post_meta($post_id, 'hide_post_share', $_POST['hide_post_share']);
	}else{
		delete_post_meta($post_id, 'hide_post_share');
	}				 
	
	if ( isset($_POST['hide_author_box']) ) {
		update_post_meta($post_id, 'hide_author_box', $_POST['hide_author_box']);
	}else{
		delete_post_meta($post_id, 'hide_author_box');
	}								 

	if ( isset($_POST['hide_related_post']) ) {
		update_post_meta($post_id, 'hide_related_post', $_POST['hide_related_post']);
	}else{
		delete_post_meta($post_id, 'hide_related_post');
	}	
	 

	if ( isset($_POST['hide_banner_below']) ) {
		update_post_meta($post_id, 'hide_banner_below', $_POST['hide_banner_below']);
	}else{
		delete_post_meta($post_id, 'hide_banner_below');
	}	
	
	if ( isset($_POST['hide_comments']) ) {
		update_post_meta($post_id, 'hide_comments', $_POST['hide_comments']);
	}else{
		delete_post_meta($post_id, 'hide_comments');
	}	 	  
	   
	  
	 
	if ( isset($_POST['video']) ) {
		update_post_meta($post_id, 'video', $_POST['video']);
	}else{
		delete_post_meta($post_id, 'video');
	}
	
	if ( isset($_POST['video_type']) ) {
		update_post_meta($post_id, 'video_type', $_POST['video_type']);
	}else{
		delete_post_meta($post_id, 'video_type');
	}	 			 		 

	if (  isset($_POST['video_url']) ) {
		update_post_meta($post_id, 'video_url', $_POST['video_url']);
	}else{
		delete_post_meta($post_id, 'video_url');
	}	 			 		 

 
	
	if ( isset($_POST['body_background_color']) ) {
		update_post_meta($post_id, 'body_background_color', $_POST['body_background_color']);
	}else{
		delete_post_meta($post_id, 'body_background_color');
	}		

	if (isset($_POST['body_background_type']) ) {
		update_post_meta($post_id, 'body_background_type', $_POST['body_background_type']);
	}else{
		delete_post_meta($post_id, 'body_background_type');
	}
	
	 		 	   


	if (  isset($_POST['body_background_image']) ) {
		update_post_meta($post_id, 'body_background_image', $_POST['body_background_image']);
	}else{
		delete_post_meta($post_id, 'body_background_image');
	}
 
	
	if (  isset($_POST['body_background_pattern']) ) {
		update_post_meta($post_id, 'body_background_pattern', $_POST['body_background_pattern']);
	}else{
		delete_post_meta($post_id, 'body_background_pattern');
	}			    
	 
 
	 		    
}