<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
 global $product,$post;
 
$class= '';
$attachment_ids = version_compare(WC()->version, '3.0.0', '<') ? $product->get_gallery_image_ids() : $product->get_gallery_image_ids();

if(!empty($attachment_ids)){
	$class.=' rd-has-gallery';
}
 
$product_image_width  = get_post_meta( $post->ID,'product_image_width',false );
 $image_width =!empty($product_image_width[0])?$product_image_width[0]:reza_option('single_product_image_width');
  $class.=' rd_img_width_'.$image_width;
?>

<aside class="rd-el-single-product rd-aw <?php echo reza_box_layout_single('product');?>">
	<div id="product-<?php the_ID(); ?>" <?php wc_product_class($class, $product); ?>>
 
	<?php do_action( 'woocommerce_before_single_product_summary' ); ?>

	<div class="rd-single-summary  rd-aw">
		<?php do_action( 'woocommerce_single_product_summary' );?>
	</div>

 
 	</div>
</aside>

<?php do_action( 'woocommerce_after_single_product_summary' ); ?>

<?php do_action( 'woocommerce_after_single_product' ); ?>
