<?php
 if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Masonry
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'sao_element_item_blog_masonry');
function sao_element_item_blog_masonry( $element ) {
 	
 	$element[]= array(
 		'name'			=> 	esc_html__('Blog Masonry','reza'),
 		'id'			=> 'blog_masonry',
		'group'			=> esc_html__('rabonews','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-masonry.jpg',
  	); 
	
	return $element;
}  
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Masonry Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_blog_masonry', 'reza_blog_masonry_options');
function reza_blog_masonry_options( $option ) {
 
	$element='blog_masonry';
			
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	 
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);		
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);		
 
 	
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
 	$masonry_fold =array('grid'=>'layout');
		
  	$meta =true;	
	
	$box_layout =true;
 	$more_posts=true;	
  	$image =true;

   	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 
 
	   
	
	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'grid',
		"type"			=> "radio_image",
   		"options"		=>  array( 
  			"grid"		=> REZA_DIR.'/admin/assets/images/grid-masonry/grid_masonry_2.jpg',
 			"featured"	=> REZA_DIR.'/admin/assets/images/featured-masonry/featured_masonry_2.jpg',
  		  
 		),						
				  
	); 
	$column=__('Column','reza');
	$option[]= array( 
		"name"			=> esc_html__('Column Layout','reza'),
 		"id"			=> "column",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> '2',
		"type"			=> "select",
   		"options"		=>  array( 
  			"2"	=> "2 $column", 
 			"3"	=> "3 $column", 
 			"4"	=> "4 $column",  
 			"5"	=> "5 $column", 
 			"6"	=> "6 $column", 
			"7"	=> "7 $column", 
 			"8"	=> "8 $column", 
 		),						
				  
	);  
 
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=> reza_array_options('responsive_column',true), 

	);

  	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
	   
    return $option;


}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Masonry Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_blog_masonry', 'reza_builder_perview_blog_masonry');
function reza_builder_perview_blog_masonry( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
		if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
		if(!empty($option['layout']) && !empty($option['column'])){
			$output.='<img src="'.REZA_DIR.'/admin/assets/images/'.$option['layout'].'-masonry/'.$option['layout'].'_masonry_'.esc_attr($option['column']).'.jpg">'; 
		}
			 
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Masonry Config
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_filter('sao_builder_blog_masonry', 'reza_blog_masonry_config');
function reza_blog_masonry_config( $args,$out = false  ) {
	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	
	if(reza_element_show($option)=='show'){

		$option['post_type']='post';
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$layout =!empty($option['layout'])?$option['layout']:'grid';
		$column =!empty($option['column'])?$option['column']:'4';
		$between_class =!empty($option['between'])? $option['between']:reza_option('blog_between'); 	
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('blog_ratio');
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('blog_alignment');
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('blog_box_layout');
		$caption_layout =!empty($option['caption_layout'])? $option['caption_layout']: reza_option('blog_caption_layout');	
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
		
	 
		
 		$layout_class='';
		if($layout=='featured'){	
			$layout_class='rd-cap-'.$caption_layout;
			$layout_class.=' rd-ratio-auto';
			
		 }else{
			$layout_class= ' rd-'.$box_layout; 
			$layout_class.= ' '.$ratio_class; 
			
		 }
 			
		$classes = array(
			'rd-el-'.$key,
			 'macy-masonry',
			'rd-ajax-tab',
			'rd-gap-'.$between_class,
			reza_between_border($option,$box_layout ),
		
			'rd-align-'.reza_alignment($alignment_class),
			$layout_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
			$custom_class,
	
		);
		
		
		ob_start(); 
		 
		?>
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_post_masonry_class($option,true) ;?> <?php echo reza_el_cssanime($option);?> >
			
			
			<?php reza_post_title_tabs($option,'reza_post_'.$layout.'_main');?>
			<div class="rd-gap-content">
			<div class="rd-gap-warp">
				<div class="rd-item-list rd-masonry  rd-aw <?php echo esc_attr(reza_post_masonry_class($option));?>"  >
 
 					<?php 
					if($layout=='grid'){
						 reza_post_grid_main($option);
					}
					if($layout=='featured'){
						 reza_post_featured_main($option);
					}
					?>
                    
 				</div>
 				
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout.'_main');
				}
				?>
					
			</div>
			</div>
 		</aside> 
	
	 
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_caption_css($option,$item);
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
	 
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		wp_enqueue_script( 'reza-masonry', REZA_DIR . '/js/lib/masonry.min.js');
	
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 