<?php

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Blog Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'add_meta_boxes', 'reza_product_metabox' );
function reza_product_metabox($post){
    add_meta_box('reza_product_general_metabox',esc_html__('Layout','reza'), 'reza_product_general_metabox', 'product', 'normal' , 'high');
  
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Blog General Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_product_general_metabox($post){
	global $post;
	wp_nonce_field( basename(__FILE__), 'reza_product_meta_nonce' );
	
	$custom = get_post_custom($post->ID);
 	$product_width  = reza_array_options('image_width',true);
  	 
 
    $product_image_width = get_post_meta($post->ID, 'product_image_width', true);
 
	
    	?>
	 
	<table class="form-table meta_box">     
		<tbody>
        	
             
       
        	
            <tr class="product_image_width">
                <th ><label for="product_image_width"><?php echo esc_html__('Image Width','reza');?></label></th>
                <td>
					<select name="product_image_width" id="product_image_width">
                          	<?php if(!empty($product_width) && is_array($product_width) ){  ?>
                        		<?php foreach ($product_width as $key => $name){  ?>
                    			<option value="<?php echo ''.esc_attr($key) ?>" <?php  if ( $product_image_width  == ''.$key ){ echo 'selected=""';} ?>><?php echo esc_html($name);?></option> 
							<?php }?>                      
							<?php }?>                      
                    </select>
                    
                </td>
            </tr>  
                        
 
                        
     	</tbody>
     </table>
    <?php
} 
add_action('save_post', 'reza_save_product_metabox');

function reza_save_product_metabox( $post_id){ 
    global $post;
    if (!isset($_POST['reza_product_meta_nonce']) || !wp_verify_nonce($_POST['reza_product_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

  if (defined('DOING_AJAX') ) {
	return $post_id;
   }
	
	if ( isset($_POST['product_image_width']) ) {
		update_post_meta($post_id, 'product_image_width', $_POST['product_image_width']);
	}else{
		delete_post_meta($post_id, 'product_image_width');
	}
  
	 
}


