<?php
 reza_mergfile();

function reza_minify_css($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')|\/\*(?!\!)(?>.*?\*\/)|^\s*|\s*$#s',
            // Remove unused white-space(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/))|\s*+;\s*+(})\s*+|\s*+([*$~^|]?+=|[{};,>~]|\s(?![0-9\.])|!important\b)\s*+|([[(:])\s++|\s++([])])|\s++(:)\s*+(?!(?>[^{}"\']++|"(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')*+{)|^\s++|\s++\z|(\s)\s+#si',
            // Replace `0(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)` with `0`
            '#(?<=[\s:])(0)(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)#si',
            // Replace `:0 0 0 0` with `:0`
            '#:(0\s+0|0\s+0\s+0\s+0)(?=[;\}]|\!important)#i',
            // Replace `background-position:0` with `background-position:0 0`
            '#(background-position):0(?=[;\}])#si',
            // Replace `0.6` with `.6`, but only when preceded by `:`, `,`, `-` or a white-space
            '#(?<=[\s:,\-])0+\.(\d+)#s',
            // Minify string value
            '#(\/\*(?>.*?\*\/))|(?<!content\:)([\'"])([a-z_][a-z0-9\-_]*?)\2(?=[\s\{\}\];,])#si',
            '#(\/\*(?>.*?\*\/))|(\burl\()([\'"])([^\s]+?)\3(\))#si',
            // Minify HEX color code
            '#(?<=[\s:,\-]\#)([a-f0-6]+)\1([a-f0-6]+)\2([a-f0-6]+)\3#i',
            // Replace `(border|outline):none` with `(border|outline):0`
            '#(?<=[\{;])(border|outline):none(?=[;\}\!])#',
            // Remove empty selector(s)
            '#(\/\*(?>.*?\*\/))|(^|[\{\}])(?:[^\s\{\}]+)\{\}#s'
        ),
        array(
            '$1',
            '$1$2$3$4$5$6$7',
            '$1',
            ':0',
            '$1:0 0',
            '.$1',
            '$1$3',
            '$1$2$4$5',
            '$1$2$3',
            '$1:0',
            '$1$2'
        ),
    $input);
}

  function reza_mergfile() {
 	$style_left='';
	
	/*
	foreach(reza_style_array() as $key => $value){
		$style_left_file =   REZA_FILE.'/css/'.$key.'.css';
		if (file_exists($style_left_file)) {
			$style_left.=file_get_contents($style_left_file);
		}
	}	
	$style_left_write = fopen("style.css", "w") or die("Unable to open file!");
 	fwrite($style_left_write, $style_left);
 	fclose($style_left_write);
	*/
	
	 
 	$style_right='';
	foreach(reza_style_array() as $key => $value){
		$style_right_file =   REZA_FILE.'/css/'.$key.'-rtl.css';
		if (file_exists($style_right_file)) {
			$style_right.=file_get_contents($style_right_file);
		}
	}	
	$style_right_write = fopen(REZA_FILE.'/css/style-rtl.min.css', "w") or die("Unable to open file!");
 	fwrite($style_right_write,$style_right);
 	fclose($style_right_write);
	
	 
 	$woocommerce_right='';
	foreach(reza_woocommerce_array() as $key => $value){
  		$woocommerce_right_file =  REZA_FILE.'/css/'.$key.'-rtl.css';
		if (file_exists($woocommerce_right_file)) {
			$woocommerce_right.=file_get_contents($woocommerce_right_file);
		}
	}	
	$woocommerce_right_write = fopen(REZA_FILE.'/css/woocommerce-rtl.min.css', "w") or die("Unable to open file!");
 	fwrite($woocommerce_right_write,$woocommerce_right);
 	fclose($woocommerce_right_write);
 
	  
 	$scripts='';
	foreach(reza_scripts_array() as $key => $value){
   	$scripts.='';
		$scripts_file =   REZA_FILE.'/js/'.$key.'.js';
		if (file_exists($scripts_file)) {
			$scripts.=file_get_contents($scripts_file);
		}
	}	
	$scripts_write = fopen(REZA_FILE.'/js/all.min.js', "w") or die("Unable to open file!");
 	fwrite($scripts_write, $scripts );
 	fclose($scripts_write);
	 

       
}
 
 