<?php
 
class reza_element_blog_featured_list extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_blog_featured_list';
	}

 
	public function get_title() {
		return __( 'نوشته های گلایدر و لیستی', 'reza' );
	}

 
	public function get_icon() {
		return 'eicon-posts-group';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
	 
		$this->register_controls_title_box();
 		$this->register_controls_general();
		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
 		$this->register_controls_caption_style();
 		$this->register_controls_typography(); 
  
	}
    




	protected function register_controls_title_box(){
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		
		$masonry_fold='';
		$layout_2_fold='';
		$excerpt_2=true;	
		$meta=true;	
		$more_page_posts=true;	
		$ratio =true;	
		$ratio_2 =true;	
		$image_width =true;	
		$image_size_2 =true;	
		$box_layout =true;
		$caption_layout =true;
		$image =true;
		 
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	
	protected function register_controls_layout(){
			
		$masonry_fold='';
		$layout_2_fold='';
		$excerpt_2=true;	
		$meta=true;	
		$more_page_posts=true;	
		$ratio =true;	
		$ratio_2 =true;	
		$image_width =true;	
		$image_size_2 =true;	
		$box_layout =true;
		$caption_layout =true;
		$image =true;
		 
		
									 

		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);
	 	
			$column=__('Column','reza');
			$layout=__('Layout','reza');
			$this->add_control(
				'featured_list_layout',
				[
					'label' => __('Layout','reza'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'featured_list_1',
 					"options"		=> [
							"featured_list_1"	=> 'گلایدر 1 ستونه و لیستی 1 ستونه',
							"featured_list_2"	=> 'گلایدر 1 ستونه و لیستی 2 ستونه',
							"featured_list_3"	=> 'گلایدر 2 ستونه و لیستی 1 ستونه',
							"featured_list_4"	=> 'گلایدر 2 ستونه و لیستی 2 ستونه',
							"featured_list_5"	=>	"$layout 5",
							"featured_list_6"	=>  "$layout 6",
							"featured_list_7"	=>  "$layout 7",
							"featured_list_8"	=>  "$layout 8",
						],
				]	 
			);	
 
		$this->add_control(
			'responsive_column',
			[ 	
				"label"			=> __('Column in Tablet and Mobile','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options" 		=> reza_array_options('first_responsive_column_2',true), 
		
				]
		);
							
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
 
 
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
		$box_layout =true;
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
	protected function register_controls_caption_style(){
		
		$image =true;
		
 		include REZA_PATH . '/elementor/general/elementor-caption-style.php';  
 	}		
	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	protected function render() {
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_2' 					=> reza_settings($option,'excerpt_2'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
					'meta_category'				=>	reza_settings($option,'meta_category'),
					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
				'hover_post_icon'			=> reza_settings($option,'hover_post_icon'),
				'more_posts' 				=> reza_settings($option,'more_posts'),
	 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'featured_list_layout' 				=> reza_settings($option,'featured_list_layout'),
 				'responsive_column'			=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
				'ratio' 					=> reza_settings($option,'ratio'),
				'ratio_2' 					=> reza_settings($option,'ratio_2'),
				'image_width'				=> reza_settings($option,'image_width'),
				'image_width_2'				=> reza_settings($option,'image_width_2'),
				'image_size'				=> reza_settings($option,'image_size'),
				'image_size_2'				=> reza_settings($option,'image_size_2'),
				'alignment' 				=> reza_settings($option,'alignment'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
				'caption_layout' 				=> reza_settings($option,'caption_layout'),
				'padding' 							=> reza_elmentor_padding($option),
				'tablet_padding' 							=> reza_elmentor_padding($option,'','tablet'),
				'mobile_padding' 							=> reza_elmentor_padding($option,'','mobile'),
   	  
	  
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_main_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_main_background'),
					'text'						=>	reza_settings($option,'title_box_main_text')
				),
				'title_box_tab_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_tab_background'),
					'text'						=>	reza_settings($option,'title_box_tab_text')
				),
				'title_box_active_color'	=> array(
					'background'				=> 	reza_settings($option,'title_box_active_background'),
					'text'						=>	reza_settings($option,'title_box_active_text')
				),
				'title_box_radius' 			=> reza_settings($option,'title_box_radius'),
				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
 			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
				'title_color'				=> array(
					'link'						=> 	reza_settings($option,'title_color_link'),
					'text'						=>	reza_settings($option,'title_color_hover')
				),
				'excerpt_color'				=>  reza_settings($option,'excerpt_color'),
				'meta_color'				=>  reza_settings($option,'meta_color'),
				'border_color' 				=> reza_settings($option,'border_color'),
				'between_border' 				=> reza_settings($option,'between_border'),								
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'radius' 					=> reza_settings($option,'radius'),
			
  			/*****************************************************************************************************************
			Caption Style
			******************************************************************************************************************/
				'image_effect' 				=> reza_settings($option,'image_effect'),
				'caption_effect'			=> reza_settings($option,'caption_effect'),
				'caption_background_color'	=> reza_settings($option,'caption_background_color'),
				'caption_color'				=> reza_settings($option,'caption_color'),
				
  			/*****************************************************************************************************************
			Typo Grap
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),
 
   		); 
  	 ?>
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_blog_featured_list_config($args,true);?>
		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
} 