<?php
 
class reza_element_blog_slider extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_blog_slider';
	}

 
	public function get_title() {
		return __( 'Blog Slider', 'reza' );
	}

 
	public function get_icon() {
		return 'eicon-post-slider';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
		$this->register_controls_title_box();
		$this->register_controls_general();
		$this->register_controls_slider();
		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
		$this->register_controls_slider_style();
		
 		$this->register_controls_caption_style();
		$this->register_controls_typography(); 
	}
    




	protected function register_controls_title_box(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		
		
	 
  	$between =true;	
 	$alignment =true;
   	$caption_layout =true;
  	$image =true;
  	$effect =true;
  	$meta =true;
 	$layout_2_fold='';			
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	protected function register_controls_slider(){
	  	$effect =true;
	  	$pager =true;
	
 		include REZA_PATH . '/elementor/general/elementor-slider.php';  
 	}
	protected function register_controls_layout(){
		
	 
	 
  	$between =true;	
 	$alignment =true;
   	$caption_layout =true;
  	$image =true;
  	$effect =true;
  	$meta =true;
 	$layout_2_fold='';	
	
		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);
		$this->add_control(
			'height',
			[
				'label'			=> __('Height','reza'),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> '500',
 				"options" 		=>array(
						'50'				=>	'50px',
						'100'				=>	'100px',
						'150'				=>	'150px',
						'200'				=>	'200px',
						'300'				=>	'300px',
						'400'				=>	'400px',
						'500'				=>	'500px', 
						'600'				=>	'600px',
						'700'				=>	'700px',
						'800'				=>	'800px',
						'900'				=>	'900px',
						'1000'				=>	'1000px',
						
					)
								 
			]	 
		);	 
 
 		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
	
  
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
	 
		$between =true;	
		$alignment =true;
		$caption_layout =true;
		$image =true;
		$meta =true;
		$effect =true;
		$layout_2_fold='';			
 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
 
	protected function register_controls_slider_style(){
		$pager =true;
 		include REZA_PATH . '/elementor/general/elementor-slider-style.php';  
 	}	 
	protected function register_controls_caption_style(){
		$image =true;
		
 		include REZA_PATH . '/elementor/general/elementor-caption-style.php';  
 	}		
  
	protected function register_controls_typography(){
		$meta =true;
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	
	
	
	
	
	protected function render() {
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
					'meta_category'				=>	reza_settings($option,'meta_category'),
					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
				'hover_post_icon'			=> reza_settings($option,'hover_post_icon'),
 			
			
			/*****************************************************************************************************************
			Slider
			******************************************************************************************************************/
				'pager'						=>  reza_settings($option,'pager'),
				'arrows' 					=> reza_settings($option,'arrows'),
				'arrow_layout'				=> array(
					'location'					=>	reza_settings($option,'arrow_location'),
					'layout'					=>	reza_settings($option,'arrow_layout'),
					'size'						=>	reza_settings($option,'arrow_size'),
				),
				'auto' 						=> reza_settings($option,'auto'),
				'effect' 						=> reza_settings($option,'effect'),
				'speed' 					=> reza_settings($option,'speed'),
				'pause' 					=> reza_settings($option,'pause'),
 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
 				'height' 					=> reza_settings($option,'height'),
 				'image_size'				=> reza_settings($option,'image_size'),
				'alignment' 				=> reza_settings($option,'alignment'),
 				'caption_layout' 			=> reza_settings($option,'caption_layout'),
				'padding' 					=> reza_elmentor_padding($option),
				'tablet_padding' 			=> reza_elmentor_padding($option,'','tablet'),
				'mobile_padding' 			=> reza_elmentor_padding($option,'','mobile'),
	  
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_main_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_main_background'),
					'text'						=>	reza_settings($option,'title_box_main_text')
				),
				'title_box_tab_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_tab_background'),
					'text'						=>	reza_settings($option,'title_box_tab_text')
				),
				'title_box_active_color'	=> array(
					'background'				=> 	reza_settings($option,'title_box_active_background'),
					'text'						=>	reza_settings($option,'title_box_active_text')
				),
				'title_box_radius' 			=> reza_settings($option,'title_box_radius'),
				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
 			 
			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
				'title_color'				=> array(
					'link'						=> 	reza_settings($option,'title_color_link'),
					'text'						=>	reza_settings($option,'title_color_hover')
				),
				'excerpt_color'				=>  reza_settings($option,'excerpt_color'),
				'meta_color'				=>  reza_settings($option,'meta_color'),
				'border_color' 				=> reza_settings($option,'border_color'),
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'radius' 					=> reza_settings($option,'radius'),
			/*****************************************************************************************************************
			Slider Style
			******************************************************************************************************************/
				'arrow_color'		=> array(
					'background'				=>	reza_settings($option,'arrow_background_color'),
					'text'						=>	reza_settings($option,'arrow_text_color')
				),
				'pager_style'		=> array(
					'pager'						=>	reza_settings($option,'pager_color'),
					'pager_actvie'				=>	reza_settings($option,'pager_active_color')
				),	
			/*****************************************************************************************************************
			Image And Caption Style
			******************************************************************************************************************/			
				'image_effect' 				=> reza_settings($option,'image_effect'),
				'caption_effect'			=> reza_settings($option,'caption_effect'),
				'caption_background_color'	=> reza_settings($option,'caption_background_color'),
				'caption_color'				=> reza_settings($option,'caption_color'),
				
  			/*****************************************************************************************************************
			Typo Grap
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),	
				
  
   		); ?>
  
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
			<?php echo reza_blog_slider_config($args,true);?>
		  
  			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
            
                 <div class="rd-elementor-script">    
					<script src='<?php echo  REZA_DIR . '/js/lib/lightslider.min.js'?>' id='sao_lightslider_script-js'></script>    
 
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
            	 
		</div>	 
 	<?php
	}
	
}
  