<?php
 
class reza_element_menu extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_menu';
	}

 
	public function get_title() {
		return __( 'فهرست', 'reza' );
	}

 
	public function get_icon() {
		return 'eicon-menu-bar';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


protected function  register_controls() {
 		$this->register_controls_general();
		$this->register_controls_layout();
		$this->register_controls_menu_style();
		$this->register_controls_typography();
 
	 
	}
    


 
	 
	protected function register_controls_general(){
 		include  REZA_PATH . '/elementor/menu/elementor-menu-general.php';  
 	}
	
 
	protected function register_controls_layout(){
 		include REZA_PATH . '/elementor/menu/elementor-menu-layout.php';  
 	}
 
 
	protected function register_controls_menu_style(){
 		include REZA_PATH . '/elementor/menu/elementor-menu-style.php';  
 	}		
	protected function register_controls_typography(){
 		include REZA_PATH . '/elementor/menu/elementor-menu-typography.php';  
 	}
 
	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
 
 		$args['option'] = array(
		
			//Title Box//
   			'title'						=> reza_settings($option,'title'),
			'menu'						=> reza_settings($option,'menu'),	
   			'number'					=> reza_settings($option,'number'),
				'padding' 							=> reza_elmentor_padding($option),
				'tablet_padding' 							=> reza_elmentor_padding($option,'','tablet'),
				'mobile_padding' 							=> reza_elmentor_padding($option,'','mobile'),			
 			'title_color'				=> array(
				'background'						=> 	reza_settings($option,'title_background_color'),
				'text'						=>	reza_settings($option,'title_text_color')
			),		
			'background_color'				=>  reza_settings($option,'background_color'),
			'menu_item_color'				=> array(
				'background'						=> 	reza_settings($option,'menu_item_color'),
				'text'						=>	reza_settings($option,'menu_item_hover_color')
			),		
			'more_color'				=> array(
				'background'						=> 	reza_settings($option,'more_background_color'),
				'text'						=>	reza_settings($option,'more_text_color')
			),	 		 
  			'border_color' 				=> reza_settings($option,'border_color'),
  			'radius' 					=> reza_settings($option,'radius'),
   			'title_typo'				=> reza_elmentor_typo_css($option,'title_typo'),
			'menu_item_typo'			=> reza_elmentor_typo_css($option,'menu_item_typo'),
			'more_typo'					=> reza_elmentor_typo_css($option,'more_typo'),
    		); 
  ?>
  
  
		<div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
			<?php echo reza_menu_config($args,true);?>
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }	?>
		</div>
    
		<?php            
 		 
	}
	
}
 
?>
