<?php
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Nav Cart
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_cart(){
 	if ( function_exists ( "is_woocommerce" )) {
 	$class_align='rd-nav-'.reza_alignment(reza_option('cart_align'));
	$class_layout=!empty(reza_option('cart_layout'))?'rd-nav-cart-'.reza_option('cart_layout'):'';
  	$classes = array(
 		'rd-nav-cart',
  		$class_align,
		$class_layout
 	);
 
	?>
		<div class="<?php echo esc_attr(join( ' ', $classes ));?>"  >		   
			<div class="widget_shopping_cart_content">
			<?php woocommerce_mini_cart();?>
            </div>
 		</div>
	<?php 
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Nav Mobile Cart
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_mobile_cart() {
	
	if ( function_exists ( "is_woocommerce" )) {
   	?>
        <div class="rd-nav-mobile-cart ">
            <?php if(!empty(reza_ismobile())){?>
                
                <div class="widget_shopping_cart_content"> 
                    <?php woocommerce_mini_cart();?>
                </div>
                
            <?php }else{?>
            
                <li><a></a><li>
    
            <?php }?>
        </div>
	
	<?php
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Nav Mini Cart
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_mini_cart() {
	 
	if ( function_exists ( "is_woocommerce" )) {
		
		$cart_layout= reza_option('cart_layout'); 
		do_action( 'woocommerce_before_mini_cart' );  
		$item_count = WC()->cart->cart_contents_count; 
		
		 
			echo '<a>';
				echo'<div class="rd-count"><span>'.reza_number_replace(esc_html($item_count)).'</span></div>';
			
				if(empty(reza_ismobile())){
					if($cart_layout=='show-price'){ 
  						echo '<span>'.reza_number_replace(WC()->cart->get_cart_subtotal()).'</span>';  
					 }elseif($cart_layout=='show-cart'){ 
   						echo '<span>'.reza_t('mycart').'</span>';  
					 } 
			 	}
				
			 echo '</a>';
			 
			 ?>
			 
			<ul class="rd-cart-warp rd-drop">
            
				<?php if ( ! WC()->cart->is_empty() ){?>
				<?php reza_mini_cart_product();?>
                
				<div class="rd-cart-stats"> 
                
                
					<div class="rd-cart-total"><strong><?php echo reza_t( 'subtotal').':';?></strong><span><?php echo reza_number_replace(WC()->cart->get_cart_subtotal());?></span></div>
                    
					<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' );?>
                    
					<div class="rd-cart-buttons"><?php do_action( 'woocommerce_widget_shopping_cart_buttons');?></div>
                    
					<?php do_action( 'woocommerce_widget_shopping_cart_after_buttons' );?>
                    
                    
				</div>
				<?php }else { ?>
					<div class="rd-cart-stats"><?php echo reza_t( 'noproducts' ); ?></div>
				<?php } ?>
		 
			</ul>
	  
		<?php
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Nav Mini Cart Product
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_mini_cart_product(){?>
 
	<ul class="rd-cart-list">
    
		<?php
		do_action( 'woocommerce_before_mini_cart_contents' );

		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
					$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
					$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
 					$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
					$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
					?>
					<li class="woocommerce-mini-cart-item <?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
						<?php
						echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
							'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">&times;</a>',
							esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
							reza_t( 'removethisitem'),
							esc_attr( $product_id ),
							esc_attr( $cart_item_key ),
							esc_attr( $_product->get_sku() )
						), $cart_item_key );
						?>
 						<?php if ( empty( $product_permalink ) ) : ?>
							<?php echo wp_kses_post($thumbnail . $product_name . '&nbsp;'); ?>
						<?php else : ?>
							<div class="rd-cart-thumb"> 
                            	 <a href="<?php echo esc_url( $product_permalink ); ?>" >
									<?php echo wp_kses_post($thumbnail); ?>
                                  </a>
                              </div>
                          
						<?php endif; ?>
                        <div class="rd-cart-details">
                        
                        	<a href="<?php echo esc_url( $product_permalink ); ?>"><?php echo wp_kses_post($product_name); ?></a>
 							<div class="rd-cart-price">
                            
								<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                                <?php echo reza_number_replace(apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key )); ?>
                                
							</div>
                            
						</div>
                         
 					</li>
 					<?php
				}
			}

		do_action( 'woocommerce_mini_cart_contents' );
		?>
	</ul>
 <?php
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Woccomrce ajax add to cart
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'reza_woocommerce_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'reza_woocommerce_ajax_add_to_cart');
function reza_woocommerce_ajax_add_to_cart() {

	$product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
	$quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
	$variation_id = absint($_POST['variation_id']);
	$passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
	$product_status = get_post_status($product_id);
	
	if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

		do_action('woocommerce_ajax_added_to_cart', $product_id);

		if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
			wc_add_to_cart_message(array($product_id => $quantity), true);
		}

		WC_AJAX :: get_refreshed_fragments();
	} else {
		
 		$data = array(
		'error' => true,
		'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));
 		echo wp_send_json($data);
	}

	wp_die();
} 