<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Carousel
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'sao_element_item_blog_carousel');
function sao_element_item_blog_carousel( $element ) {
 	
 	$element[]=array(
 		'name'			=> 	esc_html__('Blog Carousel','reza'),
 		'id'			=> 'blog_carousel',
		'group'			=> esc_html__('rabonews','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-carousel.jpg',
  	);  
	
	return $element;
}  
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Carousel Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_blog_carousel', 'reza_blog_carousel_options');
function reza_blog_carousel_options( $option =false) {
 
	$element='blog_carousel';
			
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Slider','reza'),		  
	);
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);		
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);	
	
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
	 
 	$ratio =true;	
 	$meta =true;	
 	$alignment =true;
	$box_layout =true;
  	$caption_layout =true;
  	$image =true;
	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 
	
	 
	 
	include REZA_PATH . '/sao-builder/general/sao-slider.php'; 
	
	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'list',
		"type"			=> "radio_image",
   		"options"		=>  array( 
  			"list"		=> REZA_DIR.'/admin/assets/images/list-carousel/list_carousel_1.jpg',
 			"grid"		=> REZA_DIR.'/admin/assets/images/grid-carousel/grid_carousel_1.jpg',
 			"featured"	=> REZA_DIR.'/admin/assets/images/featured-carousel/featured_carousel_1.jpg',
  		  
 		),						
				  
	); 
	$column=__('Column','reza');
	$option[]= array( 
		"name"			=> esc_html__('Column Layout','reza'),
 		"id"			=> "column",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> '1',
		"type"			=> "select",
   		"options"		=>  array( 
 			"1"	=> "1 $column", 
 			"2"	=> "2 $column", 
 			"3"	=> "3 $column", 
 			"4"	=> "4 $column",  
 			"5"	=> "5 $column",  
 			"6"	=> "6 $column", 
			"7"	=> "7 $column", 
 			"8"	=> "8 $column", 
 		  
 		),						
				  
	);  
 
	$option[]=  array( 
		"name"			=> esc_html__('Column Width in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
		"options"		=>  array(
				''				=>	esc_html__('Default','reza'),
				"150"			=> '150px',
   				"200"			=> '200px',
   				"250"			=> '250px',
   				"300"			=> '300px',
   				"350"			=> '350px',
   				"400"			=> '400px',   
				)
 	);
	
	
	
  	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
	   
  	 
    return $option;

} 

add_filter('sao_builder_perview_blog_carousel', 'reza_builder_perview_blog_carousel');
function reza_builder_perview_blog_carousel( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
	 if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
 			if(!empty($option['layout']) && !empty($option['column'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/'.$option['layout'].'-carousel/'.$option['layout'].'_carousel_'.esc_attr($option['column']).'.jpg">'; 
			}
			  
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
		return $return;
}
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Carousel config
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_blog_carousel', 'reza_blog_carousel_config');
function reza_blog_carousel_config( $args,$out = false ) {
 	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	if(reza_element_show($option)=='show'){
	
 		$option['post_type']='post';
		$layout =!empty($option['layout'])?$option['layout']:'list';
		$column =!empty($option['column'])?$option['column']:3;
		$between_class =!empty($option['between'])? $option['between']:reza_option('blog_between');
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('blog_ratio');
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('blog_alignment');
		$image_width =!empty($option['image_width'])? $option['image_width']:reza_option('blog_image_width');
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('blog_box_layout');
		$caption_layout =!empty($option['caption_layout'])? $option['caption_layout']: reza_option('blog_caption_layout');
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
	
  	 
	
		$layout_class='';
		
		$layout_class='';
		if($layout=='list'){
			$layout_class ='rd_img_width_'.$image_width;
			$layout_class.= ' rd-'.$box_layout; 	
			
		}elseif($layout=='grid'){	
			$layout_class= 'rd-'.$box_layout; 
				
		}elseif($layout=='featured'){	
			$layout_class='rd-cap-'.$caption_layout;
		} 
		
		$classes = array(
			'rd-el-'.$key,
			 'rd-slider',
			'rd-ajax-tab',
 			'rd-gap-'.$between_class,
			$ratio_class,
			reza_between_border($option,$box_layout ),
		
			'rd-align-'.reza_alignment($alignment_class),
			$layout_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
			$custom_class,
		);
		
		ob_start(); 
		?>
		
			<aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option);?> >
			
				<?php reza_post_title_tabs($option,'reza_post_'.$layout.'_main');?>
            <div class="rd-gap-slider">
                 <div class="rd-gap-content">
                <div class="rd-gap-warp dragscroll rd-aw <?php  echo esc_attr(reza_post_carousel_class($option));?>">
                <div class="rd-item-list ">
                   
                    <?php 
                    if($layout=='list'){
                        reza_post_list_main($option);
                    }
                    if($layout=='grid'){
                         reza_post_grid_main($option);
                    }
                    if($layout=='featured'){
                         reza_post_featured_main($option);
                    }
                    ?>
                    
                </div>
				</div>
            
 
                  
			</div>
            
				<?php if(!empty($option['arrows'])  && empty(reza_ismobile())){?>
					<div class="rd-arrow-warp"><a class="rd-arrow-prev"></a><a class="rd-arrow-next"></a></div>
				<?php }?>
			</div>
			<?php
            $slider_options = array(); 	
            $slider_options['speed']=  !empty($option['speed']) ? $option['speed'] : '1000';
            $slider_options['pause']= !empty($option['pause']) ? $option['pause'] : '5000';
            $slider_options['between']=   '0';	
            $slider_options['pager']= true;
            $slider_options['timer']= false;	
            $slider_options['controls']=!empty($option['arrows']) ? true : '';
            $slider_options['auto']=  !empty($option['auto']) ? true : '';
            reza_lightslider($column,$slider_options);
             ?>    
		  
		</aside> 
	
	 
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_caption_css($option,$item);
		$item_css.= reza_arrow_layout_css($option);
		$item_css.= reza_element_padding($option);
		 
		$css =reza_item_css($item_css,$item);
		
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 