<?php
/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-reviews.php
 * 
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

?>
 
 
<div class="rd-item rd-module-1" >
<div class="rd-post-product" >

     
	<div class="rd-thumb">
		<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><?php echo wp_kses_post($product->get_image()); ?></a>
	</div>
		<div class="rd-details">
		<h3 class="rd-title"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><?php echo wp_kses_post($product->get_name()); ?></a></h3>
         
		<div class="rd-rating"><?php echo wc_get_rating_html( intval( get_comment_meta( $comment->comment_ID, 'rating', true ) ) );?></div>
 
		<span class="rd-meta"><?php echo sprintf( esc_html__( 'by %s', 'reza' ), get_comment_author( $comment->comment_ID ) ); ?></span>
	</div>
      
</div>
</div>
 

