<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
$store_info   = $store_user->get_shop_info();
$map_location = $store_user->get_location();

get_header( 'shop' );

?>

<div class="rd-middle-content rd-dokan-store">
  
	<div class="rd-content rd-main">
 
 		<div class="rd-column-main">
 
		<div id="dokan-primary" class="dokan-single-store">
        <div id="dokan-content" class="store-page-wrap woocommerce" role="main">

			<div class="rd-el-product">
            <?php dokan_get_template_part( 'store-header' ); ?>
            </div>
             
            <?php
			$title_class= reza_option('title_box_style');
			$column=reza_option('related_product_column')?reza_option('related_product_column'):'4'; 

			$option = array(
				'layout'=>  'grid',
				'grid_layout'=>  'grid_4',
				'box_layout' => reza_option('product_box_layout'),
				'post_title' => 1,
				'title_limit' => reza_option('product_title_limit'),
				'excerpt' =>  0,
				'excerpt_limit' => 0,
				'list_layout' 		=>  'list_'.$column,
				'grid_layout'	 	=>  'grid_'.$column,				
  				'responsive_column' => reza_option('product_responsive_column'), 
				'thumb' => reza_option('product_thumb'), 
				'rating'  => reza_option('product_meta_rating',true),
				'addcart'  => reza_option('product_addcart',true),			
				'image_size'=>  reza_option('product_image_size'),
				'image_width'=>  reza_option('product_image_width',true),
				'image_alignment'=>  reza_option('product_image_alignment' ),
				'second_image'=>  reza_option('product_second_image' ),
				'alignment'=> reza_option('product_alignment'),
				'meta_category'  => reza_option('product_meta_category',true),
				
			  ); 
			  
			$between_class =reza_option('product_between');
			$ratio_class =reza_option('product_ratio');
			$alignment_class =reza_option('product_alignment');
			$second_image_class =reza_option('product_second_image')?'rd-has-second':'';
			$box_layout =reza_option('product_box_layout');
			$box_layout_class = 'rd-'.$box_layout;
				
			 
			$classes = array(
				'rd-el-product',
				'rd-gap-'.$between_class,
				$ratio_class,
				$second_image_class,
				'rd-align-'.reza_alignment($alignment_class),
				$box_layout_class,
			);
		?> 
    				 
 
			<section class="<?php echo esc_attr(join( ' ', $classes ));?>" data-key="shop">
                 <div class="rd-tbox-<?php echo esc_attr($title_class);?>">
                    <?php do_action( 'dokan_store_profile_frame_after', $store_user->data, $store_info ); ?>
                 </div>		

				<?php if ( have_posts() ) { ?>
						<div class="rd-gap-content">
                 	<div class="rd-gap-warp" >
						<div class="rd-item-list rd-aw rd-flex <?php echo reza_post_class($option);?> products"  >
          
                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        <?php endwhile; ?>
                        
						</div> 
                		<?php dokan_content_nav( 'nav-below' ); ?>
					</div>
					</div>
            	<?php } else { ?>

                	<p class="dokan-info"><?php esc_html_e( 'No products were found of this vendor!', 'dokan-lite' ); ?></p>

            	<?php } ?>

			</section>
 		</div>   
		</div> 
		</div>   
	</div>   
</div> 
<?php get_footer( 'shop' ); ?>
