<?php
 
class reza_element_blog_masonry extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_blog_masonry';
	}

 
	public function get_title() {
		return  __( 'Blog Masonry', 'reza' );
	}

 
	public function get_icon() {
		return 'eicon-posts-masonry';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
 
		$this->register_controls_title_box();
  		$this->register_controls_general();
 		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
		$this->register_controls_caption_style();
		$this->register_controls_typography(); 
  
	}
    




	protected function register_controls_title_box(){
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		
		$masonry_fold=['layout' => 'grid'];

		$meta =true;	
		$ratio =true;	
 		$box_layout =true;
		$more_posts=true;	
		$image =true;
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	
	protected function register_controls_layout(){
		$masonry_fold=['layout' => 'grid'];
		$ratio =true;	
		$meta =true;	
 		$box_layout =true;
		$more_posts=true;	
		$image =true;
		
		
		
		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);


		$this->add_control(
			'layout',
			[
				'label' => __('Layout','reza'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'grid',
				"options"		=> array(
				
						"grid"			=>  __('Grid','reza'), 
						"featured"		=> __('Glider','reza'), 
						
				) , 
			]	 
		);	 	
		$column=__('Column','reza');
		$this->add_control(
			'column',
			[
				'label' => __('Column Layout','reza'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				"options"		=> array(
				
					"2"	=> "2 $column", 
					"3"	=> "3 $column", 
					"4"	=> "4 $column",  
					"5"	=> "5 $column", 
					"6"	=> "6 $column", 
					"7"	=> "7 $column", 
					"8"	=> "8 $column", 
						
				),
			]	 
		);	 
		
		$this->add_control(
			'responsive_column',
			[
				'label'			=> __('Column Width in Tablet and Mobile','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options" 		=> reza_array_options('responsive_column',true), 
		
			]	 
		);	   
  
		
		
		
		
  		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
 
 
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
		$box_layout =true;
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
	protected function register_controls_caption_style(){
		$image =true;

 		include REZA_PATH . '/elementor/general/elementor-caption-style.php';  
 	}		
	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
 			 
			 
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
					'meta_category'				=>	reza_settings($option,'meta_category'),
					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
				'hover_post_icon'			=> reza_settings($option,'hover_post_icon'),
				'more_posts' 				=> reza_settings($option,'more_posts'),
 
  
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'layout' 					=> reza_settings($option,'layout'),
				'column' 					=> reza_settings($option,'column'),
				'responsive_column' 		=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
				'ratio' 					=> reza_settings($option,'ratio'),
				'image_size'				=> reza_settings($option,'image_size'),
				'alignment' 				=> reza_settings($option,'alignment'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
				'caption_layout' 			=> reza_settings($option,'caption_layout'),
				'padding' 							=> reza_elmentor_padding($option),
				'tablet_padding' 							=> reza_elmentor_padding($option,'','tablet'),
				'mobile_padding' 							=> reza_elmentor_padding($option,'','mobile'),
   	  
   	  
	  
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_main_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_main_background'),
					'text'						=>	reza_settings($option,'title_box_main_text')
				),
				'title_box_tab_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_tab_background'),
					'text'						=>	reza_settings($option,'title_box_tab_text')
				),
				'title_box_active_color'	=> array(
					'background'				=> 	reza_settings($option,'title_box_active_background'),
					'text'						=>	reza_settings($option,'title_box_active_text')
				),
				'title_box_radius' 			=> reza_settings($option,'title_box_radius'),
				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
				
			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
				'title_color'				=> array(
					'link'						=> 	reza_settings($option,'title_color_link'),
					'text'						=>	reza_settings($option,'title_color_hover')
				),
				'excerpt_color'				=>  reza_settings($option,'excerpt_color'),
				'meta_color'				=>  reza_settings($option,'meta_color'),
				'border_color' 				=> reza_settings($option,'border_color'),
				'between_border' 				=> reza_settings($option,'between_border'),
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'radius' 					=> reza_settings($option,'radius'),
   			
			/*****************************************************************************************************************
			Image And Caption Style
			******************************************************************************************************************/		
				'image_effect' 				=> reza_settings($option,'image_effect'),
				'caption_effect'			=> reza_settings($option,'caption_effect'),
				'caption_background_color'	=> reza_settings($option,'caption_background_color'),
				'caption_color'				=> reza_settings($option,'caption_color'),
				
  			/*****************************************************************************************************************
			Typo 
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),	
				
	 
   		);?>
  
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
 		 
         		
			<?php echo reza_blog_masonry_config($args,true);?>
		  
 			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script"> 
                 
						<script src='<?php echo  REZA_DIR . '/js/lib/masonry.min.js'?>' id='reza-masonry-js'></script>    
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
    
    <?php
    }
	
} 