<?php
 
class reza_element_product_carousel extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_product_carousel';
	}

 
	public function get_title() {
		return __( 'Product Carousel', 'reza' );
	}

 
	public function get_icon() {
		return 'eicon-posts-carousel';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
	
		$this->register_controls_title_box();
 		$this->register_controls_general();
		$this->register_controls_slider();
		$this->register_controls_layout();
		 $this->register_controls_featured();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
		$this->register_controls_slider_style();
		
		$this->register_controls_typography(); 
 
	}
    




	protected function register_controls_title_box(){
 		include  REZA_PATH . '/elementor/product/elementor-product-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
 		include  REZA_PATH . '/elementor/product/elementor-product-carousel-general.php';  
 	}
	protected function register_controls_slider(){
 		include REZA_PATH . '/elementor/general/elementor-slider.php';  
 	}
	protected function register_controls_layout(){
 		include REZA_PATH . '/elementor/product/elementor-product-carousel-layout.php';  
 	}
	
	protected function register_controls_featured(){
 		include REZA_PATH . '/elementor/product/elementor-product-featured.php';  
 	}
	
 
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
 		include REZA_PATH . '/elementor/product/elementor-product-style.php';  
 	}	
 
	protected function register_controls_slider_style(){
 		include REZA_PATH . '/elementor/general/elementor-slider-style.php';  
 	}	 
 
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/product/elementor-product-typography.php';  
 	}	  
	protected function render() {
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),				
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
 				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
					'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),				
			
				'countdown'					=> 	reza_settings($option,'countdown'),
				'meta_category'				=>	reza_settings($option,'meta_category'),
 				'rating'					=>	reza_settings($option,'rating'),
				'addcart'					=>	reza_settings($option,'addcart'),
 	 
			/*****************************************************************************************************************
			Slider
			******************************************************************************************************************/
				'pager'						=>  reza_settings($option,'pager'),
				'arrows' 					=> reza_settings($option,'arrows'),
				'arrow_layout'				=> array(
					'location'					=>	reza_settings($option,'arrow_location'),
					'layout'					=>	reza_settings($option,'arrow_layout'),
					'size'						=>	reza_settings($option,'arrow_size'),
				),
				
				
				'auto' 						=> reza_settings($option,'auto'),
				'speed' 					=> reza_settings($option,'speed'),
				'pause' 					=> reza_settings($option,'pause'),
				
				
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'layout' 					=> reza_settings($option,'layout'),
				'column' 					=> reza_settings($option,'column'),
  				'row'						=> reza_settings($option,'row'),
  				'responsive_column'			=> reza_settings($option,'responsive_column'),
 				'between' 					=> reza_settings($option,'between'),
				'ratio' 					=> reza_settings($option,'ratio'),
 				'image_width'				=> reza_settings($option,'image_width'),
 				'image_size'				=> reza_settings($option,'image_size'),
 				'second_image'				=> reza_settings($option,'second_image'),
 				'alignment' 				=> reza_settings($option,'alignment'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
				'padding'					=> reza_elmentor_padding($option),
				'tablet_padding'			=> reza_elmentor_padding($option,'','tablet'),
				'mobile_padding'			=> reza_elmentor_padding($option,'','mobile'),
   	  
			/*****************************************************************************************************************
			Featured Item
			******************************************************************************************************************/
	  
				'image_featured'			=> reza_settings($option,'image_featured'),
				'image_featured_query' 		=> reza_settings($option,'image_featured_query'),
				'sliders'					=> reza_settings($option,'sliders'),
				'image_featured_id'			=>  !empty($image_featured_id['id'])?$image_featured_id['id']:'',
				'image_featured_image_size'	=> reza_settings($option,'image_featured_image_size'),
				'image_featured_image_link'	=> reza_settings($option,'image_featured_image_link'),
				'image_featured_image_url'	=> reza_settings($option,'image_featured_image_url'),
				'image_featured_width'		=> reza_settings($option,'image_featured_width'),
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_main_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_main_background'),
					'text'						=>	reza_settings($option,'title_box_main_text')
				),
				'title_box_tab_color'		=> array(
					'background'				=> 	reza_settings($option,'title_box_tab_background'),
					'text'						=>	reza_settings($option,'title_box_tab_text')
				),
				'title_box_active_color'	=> array(
					'background'				=> 	reza_settings($option,'title_box_active_background'),
					'text'						=>	reza_settings($option,'title_box_active_text')
				),
				'title_box_radius' 			=> reza_settings($option,'title_box_radius'),
				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
				
				
			/*****************************************************************************************************************
			Product Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
				'title_color'				=> array(
					'link'						=> 	reza_settings($option,'title_color_link'),
					'text'						=>	reza_settings($option,'title_color_hover')
				),
				'price_color'		=> array(
					'main'						=>	reza_settings($option,'price_main_color'),
					'sale'						=>	reza_settings($option,'price_sale_color'),
					'regular'					=>	reza_settings($option,'price_regular_color'),
				),
				'excerpt_color'					=>  reza_settings($option,'excerpt_color'),
				'meta_color'					=>  reza_settings($option,'meta_color'),
				'rating_color'		=> array(
					'rating'						=>	reza_settings($option,'rating_rating_color'),
					'none'						=>	reza_settings($option,'rating_none_color')
				),
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'between_border' 				=> reza_settings($option,'between_border'),
				'border_color' 				=> reza_settings($option,'border_color'),
				'radius' 					=> reza_settings($option,'radius'),
			/*****************************************************************************************************************
			Slider Style
			******************************************************************************************************************/
				'arrow_color'		=> array(
					'background'				=>	reza_settings($option,'arrow_background_color'),
					'text'						=>	reza_settings($option,'arrow_text_color')
				),

  			/*****************************************************************************************************************
			Typo
			******************************************************************************************************************/	
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'price_typo'				=> reza_elmentor_typo_css($option,'price'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),
 
 
   		); 
  	 ?>
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_product_carousel_config($args,true);?>
		  
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
					<script src='<?php echo  REZA_DIR . '/js/lib/lightslider.min.js'?>' id='sao_lightslider_script-js'></script>    

                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
}