<?php
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_nav_menu($location=false,$align=false) {
	$classes = array(
 		'menu',
 		'rd-nav-menu',
  		'rd-nav-'.reza_alignment(reza_option(esc_html($align))),
   	);
	
	if(has_nav_menu($location)){
 		wp_nav_menu( array( 'container' => '', 'fallback_cb' => 'reza_menu_fallback','menu_class' => join( ' ', $classes ), 'theme_location' => $location, 	'walker' => new reza_Walker_Nav_Menu ) );  
	}else{ 
		echo  '<ul class="'.esc_attr(join( ' ', $classes )) .'"><li><a href="'.esc_url(home_url( '/') ).'wp-admin/nav-menus.php">'.__('Set menu','reza').'</a></li></ul>';
	 
	}
}
 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Category Menu
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_category_menu() {
 	if( is_singular()) {
		global $post;
		$meta = get_post_meta( $post->ID );
	}  	
	global $smof_data;
 	if(!empty( $meta['sub_category_menu'][0] )){
		$sub_category_menu =  $meta['sub_category_menu'][0];  
	}else {
 		$sub_category_menu = is_front_page() && !empty($smof_data['sub_category_menu']) ? $smof_data['sub_category_menu'] :reza_option_default('sub_category_menu');  			
	} 
 		
 	$class_sub=$sub_category_menu == 'enable'?'rd-cat-sub ':''; 
   	$class_width = 'rd_col_'.str_replace("-","_",reza_option('category_menu_width')); 	
	
	$classes = array(
 		'rd-nav-cat-menu',
    	$class_width ,
		$class_sub,
     );
	
 	?>
	
    <div class="<?php echo esc_attr(join( ' ', $classes ));?>">
 		<li><a><?php echo reza_option('category_menu_title'); ?><i></i></a>
			<?php 
			if(has_nav_menu('reza_category_menu')){
				wp_nav_menu( array( 'container' => '','menu_class' => 'menu rd-cat-drop', 'theme_location' => 'reza_category_menu', 	'walker' => new reza_Walker_Nav_Menu ) );  
			}else{ 
				echo  '<ul class="menu rd-cat-drop"><li><a href="'.esc_url(home_url( '/') ).'wp-admin/nav-menus.php">'.__('Set menu','reza').'</a></li></ul>';
	 
		}?>
        </li>
  	</div>
    
	<?php
	 
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu Featured
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_menu_featured($featured=false) {
	if(!empty($featured)){
		echo '<span class="rd-menu-tags-'.esc_attr($featured).'">';
		if($featured == 'new'){
			echo reza_t('new');
		}elseif($featured == 'sale'){
			echo  reza_t('sale') ;
		}elseif($featured == 'hot'){
			echo   reza_t('hot') ;
		}elseif($featured == 'featured'){
			echo reza_t('featured')  ;
		}
			echo '</span>';
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu Icon Size
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_menu_icon_size($size=false) {
	if($size=='fa-1x'){
 		return '--rd-nav-icn-sz:1em;';
	}elseif($size=='fa-1-25x'){
 		return '--rd-nav-icn-sz:1.25em;';
	}elseif($size=='fa-1-5x'){
 		return '--rd-nav-icn-sz:1.5em;';
 	}elseif($size=='fa-1-75x'){
 		return '--rd-nav-icn-sz:1.75em;';
 	}elseif($size=='fa-2x'){
 		return '--rd-nav-icn-sz:2em;';
   	}elseif($size=='fa-2-5x'){
 		return '--rd-nav-icn-sz:2.5em;';
  	}elseif($size=='fa-3x'){
 		return '--rd-nav-icn-sz:3em;';
 	}elseif($size=='fa-3-5x'){
 		return '--rd-nav-icn-sz:3.5em;';
 	}elseif($size=='fa-4x'){
 		return '--rd-nav-icn-sz:4em;';
 	}elseif($size=='fa-4-5x'){
 		return '--rd-nav-icn-sz:4.5em;';
 	}elseif($size=='fa-5x'){
 		return '--rd-nav-icn-sz:5em;';
 	}else{
 		return '';
	}
 	
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu Background
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_menu_background($args=false) {
	 $css='';
  	
	if(!empty($args['image'])){
		$img= wp_get_attachment_image_src($args['image'],'full');
		if(!empty($img[0])){
			
 			$css.= ' --rd-menu-bg-img:url('.esc_url($img[0]).');';
  
  			if(!empty($args['size'])){
				$css.= ' --rd-menu-bg-sz:'.$args['size'].';';
			}
    			if(!empty($args['position'])){
				$css.= ' --rd-menu-bg-pos:'.reza_alignment($args['position']).';';
			}
	
			if(!empty($args['opacity'])){
				$css.= ' --rd-menu-bg-op:'.$args['opacity'].';';
			}
		}

	} 
	return $css;
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu Width
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_menu_width($size=false) {
	if($size=='200'){
 		return '--rd-drp-wt:200px;';
	}elseif($size=='300'){
 		return '--rd-drp-wt:300px;';
	}elseif($size=='400'){
 		return '--rd-drp-wt:400px;';
 	}elseif($size=='500'){
 		return '--rd-drp-wt:500px;';
 	}elseif($size=='600'){
 		return '--rd-drp-wt:600px;';
   	}elseif($size=='700'){
 		return '--rd-drp-wt:700px;';
  	}elseif($size=='800'){
 		return '--rd-drp-wt:800px;';
 	}elseif($size=='900'){
 		return '--rd-drp-wt:900px;';
 	}elseif($size=='1000'){
 		return '--rd-drp-wt:1000px;';
 
 	}elseif($size=='full-width'){
 		return '--rd-drp-wt:100%;';
 
 	}else{
 		return '';
	}
 	
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Nav Menu Mobile Width
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_nav_mobile_menu($featured=false) {?>
   	<div class="rd-nav-mobile-menu">
		<li><a></a></li>
		<?php 
		if(has_nav_menu('reza_mobile_menu')){
			wp_nav_menu( array( 'container' => false, 'menu_class' => 'rd-nav-menu', 'theme_location' =>  'reza_mobile_menu',  	'walker' => new reza_Walker_Nav_Menu_Mobile ) ); 
		}else{
		 	echo  '<ul class="rd-nav-menu"><li><a href="'.esc_url(home_url( '/') ).'wp-admin/nav-menus.php">'.__('Set menu','reza').'</a></li></ul>';
		}
		?>
      </div>
	<?php
	
 
}