(function($) {
    $.fn.reza_woocommerce = function() {

        $(document).on('click', '.rd-qty-plus,.rd-qty-minus', function() {
            var qty = $(this).closest('.quantity').find('.qty');
            if (qty.val() == '') {
                var val = 0;
            } else {
                var val = parseInt(qty.val());
            }
            var max = parseFloat(qty.attr('max'));
            var min = parseFloat(qty.attr('min'));
            var step = parseFloat(qty.attr('step'));

            if ($(this).is('.rd-qty-plus')) {
                if (max && (max <= val)) {
                    qty.val(max);
                } else {
                    qty.val(val + step);
                }
            } else {

                if (min && (min >= val)) {
                    qty.val(min);

                } else if (val >= 1) {
                    qty.val(val - step);
                }
            }
			
			$('button[name="update_cart"]').attr('aria-disabled','false').removeAttr('disabled');
			
        });

        jQuery(document).bind("change keyup mousedown keydown price_slider_create price_slider_slide mousemove mouseover", ".price_slider", function() {
            var from = $('body').reza_translate($(this).find('.price_label .from').text());
            $(this).find('.price_label .from').text(from);

            var to = $('body').reza_translate($(this).find('.price_label .to').text());
            $(this).find('.price_label .to').text(to);
        });


        $('.rd-rating .count,.rd-title .count span').each(function(index, block) {
            var reza = $(this).text();
            $(this).html($('body').reza_translatepad(reza));
        });
    };
}(jQuery));