<?php
if(is_admin()){

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Search Field
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_filter('sao_element_item', 'sao_element_item_search_field');
function sao_element_item_search_field( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	esc_html__('Search Field','reza'),
 		'id'			=> 'search_field',
		'group'			=> esc_html__('rabonews','reza'),
		
		'img'			=>  REZA_DIR.'/admin/assets/images/element-search.jpg',
		
   	); 
   
	
	return $element;
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Search Field Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_search_field', 'reza_search_field_options');
function reza_search_field_options( $option ) {
 
 
	$option[]= array( 
		"name"			=> esc_html__('Placeholder','reza'),
 		"id"			=> "placeholder",
  		"type"			=> "text",
		"default"		=>  reza_t('searchitem'),
		
 	);
  	$option[]= array( 
		"name"			=> __('Search Button Type','reza'),
 		"id"			=> "search_button_type",
  		"type"			=> "select",
 		"options"		=> array(
 			"icon" => esc_html__('Icon','reza'),	
			"text" => esc_html__('Text','reza'),	
		
		),
		
 	); 
	$option[]= array( 
		"name"			=> __('Width','reza'),
 		"id"			=> "width",
  		"group"			=>  __('Layout','reza'),
 		"type"			=> "select",
 		"options"		=> array(
 			"" =>esc_html__('Default','reza'),
			"100%" =>  '100%',
			"95%" =>  '95%',
			"90%" =>  '90%',
			"85%" =>  '85%',
			"80%" =>  '80%',
			"75%" =>  '75%',
			"70%" =>  '70%',
			"65%" =>  '65%',
			"60%" =>  '60%',
			"55%" =>  '55%',
			"50%" =>  '50%',
			"45%" =>  '45%',
			"40%" =>  '40%',
			"35%" =>  '35%',
			"30%" =>  '30%',
			"25%" =>  '25%',
			"20%" =>  '20%',
  	
		),
  	);	
	
	
 	$option[]= array( 
		"name"			=> __('Height','reza'),
 		"id"			=> "height",
  		"group"			=>  __('Layout','reza'),
 		"type"			=> "number",
  	);		
			
	$option[]= array( 
		"name"			=> __('Alignment','reza'),
 		"id"			=> "alignment",
  		"group"			=>  __('Layout','reza'),
 		"type"			=> "select",
  		"options"		=>  reza_array_options('alignment_inverse',true),						
		
 		 
	);
 
 	 
	
	 
	$option[]= array( 
		"name"			=> esc_html__('Search Style','reza'),
 		"id"			=> "search_style",
 		"group"			=>  esc_html__('Search Style','reza'),
   		"type"			=> "multi_options",
 		"options"			=>	array( 	
		
			array( 
 				"name"			=> 	__('Background Color','reza'),
 				"id"			=> "background",
  				"type"			=> "color_rgba",
  			),
			array( 
				"name"			=> __('Text Color','reza'),			
  				"id"			=> "text",
				"type"			=> "color_rgba",
 			),
		 
		),
   	); 	
	
$option[]= array( 
		"name"			=> esc_html__('Search Button Style','reza'),
 		"id"			=> "search_button_style",
 		"group"			=>  esc_html__('Search Style','reza'),
   		"type"			=> "multi_options",
 		"options"			=>	array( 	
 			
			array( 
 				"name"			=> 	__('Background','reza'),
 				"id"			=> "background",
  				"type"			=> "color_rgba",
  			),
			array( 
				"name"			=> __('Text Color','reza'),			
  				"id"			=> "text",
				"type"			=> "color_rgba",
 			),
		
 		 
		),							
   	); 	
	
	$option[]= array( 
		"name"			=> __('Search Border','reza'),
 		"id"			=> "search_border_color",
		"group"			=>  esc_html__('Search Style','reza'),
 		"type"			=> "color_rgba",
	); 	
	
	 
 	$option[]= array( 
		"name"			=> __('Search Border Radius','reza'),
 		"id"			=> "search_radius",
 		"group"			=>  esc_html__('Search Style','reza'),
 		"type"			=> "select",
  		"options"		=>  reza_array_options('radius',true),						
	 
	); 	 
 	
 
 
	$option[]= array( 
		"name"			=> esc_html__('Text Typography','reza'),
 		"id"			=> "text_typo",
  		"group"			=>  esc_html__('Typography','reza'),
   		"type"			=> "multi_options",
		"options"		=>	reza_multi_array_options('typo')
		 
	);
			
	   	include REZA_PATH . '/sao-builder/general/sao-element.php';

    return $option;
} 
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Search Field Config
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_search_field', 'reza_search_field_config');
function reza_search_field_config( $args,$out=false ) {
 
 	$option = $args['option'];
	$key = $args['key'];
	if(reza_element_show($option)=='show'){
		$output='';
		$css ='';
 		$placeholder =!empty($option['placeholder'])?$option['placeholder']:'';
		$button_type =!empty($option['search_button_type'])?$option['search_button_type']:'icon';
		$alignment_class =!empty($option['alignment'])?$option['alignment']:'center';
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';
		if(function_exists ( "is_woocommerce" )){
			 $default ='product';
		}else{
			$default ==reza_option('searchform_post_type');	
		}
		$searchform_post_type= !empty($option['searchform_post_type'])?$option['searchform_post_type'] :$default;
				 
		$classes = array(
			'rd-el-'.$key,
			'rd-search-'.$button_type,
			'rd-searchfield',
			'rd-aw',
			'rd-align-'.reza_alignment_inverse($alignment_class),
			reza_element_show($option,true),
			$custom_class		
		);
	 
		ob_start(); 
		
		?>
		 <aside <?php  reza_el_id($option);?>  class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option);?> >
	
			<form method="get" class="rd-search" action="<?php echo esc_url(home_url( '/') );?>">
							 
					<input type="text" name="s"  value="" placeholder="<?php echo esc_html($placeholder);?>" />
					
 						<input type="hidden" name="post_type" value="product">
 							 
					
					<?php if($button_type=='text' ){?>
						<button type="submit" name="btnSubmit"  ><?php echo reza_t('search');?></button>
					<?php }else{?>
						<button type="submit" name="btnSubmit" ></button>
					<?php } ?>
							
			</form>
		</aside>
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css=
			reza_var('--rd-srh-wt',$option,'width').
			reza_var_unit('--rd-srh-ht',$option,'height').
			reza_var_2('--rd-srh-txt-bg',$option,'search_style','background').
			reza_var_2('--rd-srh-txt-txt',$option,'search_style','text').
			reza_var_2('--rd-srh-btn-bg',$option,'search_button_style','background').
			reza_var_2('--rd-srh-btn-txt',$option,'search_button_style','text').
			reza_var('--rd-srh-br-cr',$option,'search_border_color').
			reza_var('--rd-srh-rd',$option,'search_radius').
			reza_var_font_typo('--rd-srh',$option,'text_typo');   			
	
		
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
	
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 